//Listing 16.5. Przykad wykorzystania przedrostkowych oraz przyrostkowych operatorw inkrementacji
#include <iostream>
using namespace std;

class String {
  int size; // rozmiar acucha
  char *str; // pocztek acucha wewntrznego
  char *ptr; // wskanik do biecego sumbolu
  void set(const char* s); // przydzia acucha prywatnego
public:
  String (const char* s = "") // konstruktor konwertujcy oraz domylny
    { set(s); }
  String (const String &s) // konstruktor kopiujcy
    { set(s.str); }
  ~String() // destruktor
    { delete [ ] str; }
  String& operator = (const String& s); // przypisanie
  char* operator++(); // przedrostkowy operator inkrementacji
  char* operator++(int); // przyrostkowy operator inkrementacji
  int getSize() const; // biecy rozmiar acucha
  char* reset(); } ; // brak const: obiekt jest zmieniany

void String::set(const char* s)
{ size = strlen(s); // oblicz rozmiar
  str = new char[size + 1]; // zadaj pamici na stercie
  if (str == 0) { cout << "Brak pamici\n"; exit(0); }
  strcpy(str,s); // skopiuj dane klienta na stert
  ptr = str; } // zainicjalizuj wskanik

String& String::operator = (const String& s)
{ if (this == &s) return *this; // nie wykonuj nic gdy przypisanie do tego samego obiektu
  delete [ ] str; // zwr istniejc pami
  set(s.str); // przydziel (ustaw) nowy obszar pamici
  return *this; } // w celu obsugi przypisywania w acuchu

int String::getSize() const // brak zmian dla obiektu String
{ return size; }

char* String::reset() // brak const: obiekt zostaje zmieniony
{ ptr = str; // ustaw biecy wskanik na pocztek
  return str; } // zwr wskanik na pocztek

char* String::operator ++() // zwr wartos a nastpnie zwiksz
{ if (ptr-str < size) // sprawd czy pami jest dostpna
    return ++ptr; // wskanik do kolejnego znaku
  else
    { *ptr = 0; // ustaw kocowy znak zero
   return ptr; } }

char* String::operator ++(int) // zwiksz a nastpnie zwr wartos
{ if (ptr-str < size) // sprawd czy pami jest dostpna
    return ptr++; // wskanik do kolejnego znaku
  else
    { *ptr = 0; // ustaw kocowy znak zero
    return ptr; } } // nie przesuwaj jeli jest na kocu

void printString(String& data) // brak const: acuch jest zmieniany
{ char *p = data.reset(); // wska na pocztkowy znak
  while (*p != 0) // przejd do koca znakw
  { cout << *p; // wypisz kolejny znak
    p = ++data; } // wska na kolejny znak
  cout << endl; }

void modifyString(String& data, const char text[])
{ data.reset(); // wska na pierwszy znak
  int len = strlen(text) + 1; // ustaw limit iteracji
  for (int i=0; i < len; i++) // przetwrz kady znak
    *data++ = text[i]; } // adna skadnia: skopiuj znak

int main()
{
  String data = "Witaj, wiecie!";
  printString(data); // prawidowe dane wyjciowe
  modifyString(data,"Jaka jest pogoda?");
  printString(data); // Pami NIE jest uszkodzona
  return 0;
}
